<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class SendProfileVerifiedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Profile Verified Successfully')
            ->line('Dear '.$notifiable->name.',')
            ->line('We are pleased to inform you that your profile on '.env('APP_NAME').' has been successfully verified.')
            ->line('With a verified profile, you can now take full advantage of the enhanced features and opportunities on our platform.')
            ->line('Thank you for your cooperation throughout the verification process. We wish you the best in your job search.');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title' => __('Your profile on '.env('APP_NAME').'has been successfully verified.'),
            'url' => route('company.dashboard'),
        ];
    }
}
